/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class NetworkInputBuffer {
    volatile int currentlen = 0;
    ByteBuffer b = null;
    int maxlen = 0;
    InputStream datain = null;
    boolean error_happened = false;
    byte[] bb = new byte[32000];
    BufferedInputStream bis = null;

    public NetworkInputBuffer(InputStream inout, int howbig) {
        this.datain = inout;
        this.b = ByteBuffer.allocate(howbig + 200);
        this.maxlen = howbig;
        this.bis = new BufferedInputStream(this.datain, this.bb.length);
    }

    public void close() {
    }

    public boolean errorOccurred() {
        return this.error_happened;
    }

    private void getAtLeast(int min) {
        int newval;
        boolean readshort;
        int maxread;
        block18: {
            if (this.currentlen >= min) {
                return;
            }
            if (this.error_happened) {
                this.b.rewind();
                this.b.position(0);
                return;
            }
            maxread = 0;
            readshort = false;
            if (this.currentlen > 0) {
                byte[] b1 = this.b.array();
                int i = 0;
                while (i < this.currentlen) {
                    b1[i] = this.b.get();
                    ++i;
                }
            }
            this.b.position(this.currentlen);
            try {
                maxread = this.bis.available();
            }
            catch (IOException e1) {
                this.error_happened = true;
                if (DangerZone.start_client) {
                    DangerZone.gameover = 1;
                }
                this.b.rewind();
                this.b.position(0);
                return;
            }
            if (maxread < min - this.currentlen) {
                maxread = min - this.currentlen;
            }
            if (maxread > this.maxlen - this.currentlen) {
                maxread = this.maxlen - this.currentlen;
            }
            if (maxread > this.bb.length) {
                maxread = this.bb.length;
            }
            newval = maxread;
            try {
                newval = this.currentlen != 0 ? this.bis.read(this.bb, 0, maxread) : this.bis.read(this.b.array(), 0, maxread);
            }
            catch (IOException e) {
                this.error_happened = true;
                if (!DangerZone.start_client) break block18;
                DangerZone.gameover = 1;
            }
        }
        if (newval != maxread) {
            if (newval <= 0) {
                System.out.printf("maxread mismatch %d vs %d player quit?\n", newval, maxread);
                this.error_happened = true;
                if (DangerZone.start_client) {
                    DangerZone.gameover = 1;
                }
            } else {
                readshort = true;
            }
        }
        if (this.currentlen != 0) {
            this.b.put(this.bb, 0, newval);
        }
        this.currentlen += newval;
        this.b.rewind();
        this.b.position(0);
        if (readshort && this.currentlen < min) {
            this.getAtLeast(min);
        }
    }

    public int readInt() {
        if (this.error_happened) {
            return 0;
        }
        if (this.currentlen < 4) {
            this.getAtLeast(4);
            if (this.error_happened) {
                return 0;
            }
        }
        this.currentlen -= 4;
        return this.b.getInt();
    }

    public short readShort() {
        if (this.error_happened) {
            return 0;
        }
        if (this.currentlen < 2) {
            this.getAtLeast(2);
            if (this.error_happened) {
                return 0;
            }
        }
        this.currentlen -= 2;
        return this.b.getShort();
    }

    public byte readByte() {
        if (this.error_happened) {
            return 0;
        }
        if (this.currentlen < 1) {
            this.getAtLeast(1);
            if (this.error_happened) {
                return 0;
            }
        }
        --this.currentlen;
        return this.b.get();
    }

    public float readFloat() {
        if (this.error_happened) {
            return 0.0f;
        }
        if (this.currentlen < 4) {
            this.getAtLeast(4);
            if (this.error_happened) {
                return 0.0f;
            }
        }
        this.currentlen -= 4;
        return this.b.getFloat();
    }

    public double readDouble() {
        if (this.error_happened) {
            return 0.0;
        }
        if (this.currentlen < 8) {
            this.getAtLeast(8);
            if (this.error_happened) {
                return 0.0;
            }
        }
        this.currentlen -= 8;
        return this.b.getDouble();
    }

    public long readLong() {
        if (this.error_happened) {
            return 0L;
        }
        if (this.currentlen < 8) {
            this.getAtLeast(8);
            if (this.error_happened) {
                return 0L;
            }
        }
        this.currentlen -= 8;
        return this.b.getLong();
    }

    /*
     * Unable to fully structure code
     */
    public String readString() {
        block5: {
            if (this.error_happened) {
                return null;
            }
            stringbytes = this.readByteArray();
            if (stringbytes == null) {
                return null;
            }
            s = null;
            try {
                s = new String(stringbytes, "UTF-8");
                break block5;
            }
            catch (UnsupportedEncodingException e) {
                s = new String();
                i = 0;
                ** while (i < stringbytes.length)
            }
lbl-1000:
            // 1 sources

            {
                s = String.valueOf(s) + (char)stringbytes[i];
                ++i;
                continue;
            }
        }
        return s;
    }

    public short[] readShortArray() {
        int len = this.readInt();
        if (len <= 0) {
            return null;
        }
        short[] sh = new short[len];
        this.getAtLeast(len * 2);
        if (this.error_happened) {
            return null;
        }
        int i = 0;
        while (i < len) {
            sh[i] = this.b.getShort();
            ++i;
        }
        this.currentlen -= len * 2;
        return sh;
    }

    public byte[] readByteArray() {
        int len = this.readInt();
        if (len <= 0) {
            return null;
        }
        byte[] sh = new byte[len];
        this.getAtLeast(len);
        if (this.error_happened) {
            return null;
        }
        this.b.get(sh, 0, len);
        this.currentlen -= len;
        return sh;
    }
}

